#include <cstdio>
#include <vector>
using namespace std;

vector<vector<int> > g;
vector<int> mt_girl_to_boy;
vector<int> mt_boy_to_girl;
int n;

vector<vector<int> > ans;

vector<int> used;

int closed_girl;

bool try_khun(int boy)
{
    used[boy] = 1;
    for (int i = 0; i < (int) g[boy].size(); ++i) {
        int girl = g[boy][i];

        if (girl == closed_girl) {
            continue;
        }

        if (mt_girl_to_boy[girl] == -1) {
            mt_girl_to_boy[girl] = boy;
            mt_boy_to_girl[boy] = girl;

            return true;
        }

    }

    for (int i = 0; i < (int) g[boy].size(); ++i) {
        int girl = g[boy][i];

        if (girl == closed_girl) {
            continue;
        }

        int new_boy = mt_girl_to_boy[girl];

        if (!used[new_boy] && try_khun(new_boy)) {
            mt_boy_to_girl[boy] = girl;
            mt_girl_to_boy[girl] = boy;

            return true;
        }
    }

    return false;
}

bool try_relax(int v, int u)
{
    int v_g = mt_boy_to_girl[v];
    int u_b = mt_girl_to_boy[u];

    mt_boy_to_girl[v] = u;
    mt_girl_to_boy[u] = v;

    mt_boy_to_girl[u_b] = -1;
    mt_girl_to_boy[v_g] = -1;

    closed_girl = u;

    used.assign(n, false);
    if (try_khun(u_b)) {
        for (int i = 0; i < n; ++i) {
            ans[i][mt_boy_to_girl[i]] = 1;
        }
        return true;
    } else {
        mt_boy_to_girl[v] = v_g;
        mt_girl_to_boy[v_g] = v;

        mt_boy_to_girl[u_b] = u;
        mt_girl_to_boy[u] = u_b;
        return false;
    }
}

int main()
{
    scanf("%d", &n);
    g.resize(n);
    for (int i = 0; i < n; ++i) {
        int k;
        scanf("%d", &k);
        for (int j = 0; j < k; ++j) {
            int v;
            scanf("%d", &v);
            --v;
            g[i].push_back(v);
        }
    }

    mt_girl_to_boy.resize(n);
    mt_boy_to_girl.resize(n);
    for (int i = 0; i < n; ++i) {
        int v;
        scanf("%d", &v);
        --v;
        mt_girl_to_boy[v] = i;
        mt_boy_to_girl[i] = v;
    }

    ans.resize(n, vector<int>(n, 0));
    for (int i = 0; i < n; ++i) {
        ans[i][mt_boy_to_girl[i]] = 1;
    }

    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < (int) g[i].size(); ++j) {
            int v = g[i][j];
            if (!ans[i][v]) {
                if (try_relax(i, v)) {
                    ans[i][v] = 1;
                }
            }
        }
    }

    for (int i = 0; i < n; ++i) {
        int c = 0;
        for (int j = 0; j < n; ++j) {
            c += ans[i][j];
        }
        printf("%d ", c);
        for (int j = 0; j < n; ++j) {
            if (ans[i][j]) {
                printf("%d ", j + 1);
            }
        }
        printf("\n");
    }


    return 0;
}
